const { execSync } = require('child_process');

const https = require('https');
const fs = require('fs');
const crypto = require('crypto');

// This new and improved program fetches relevant data for generating
// star data.

// Should accept multiple configs while avoid downloading duplicate data

const delay = ms => new Promise(resolve => setTimeout(resolve,ms));

var metars = [];
var zones = [];
var mesos = [];
var wfos = [];
var gridpoints = [];
var zips = [];

function Usage() {

}

function GetConfig(cf) {
	var c = fs.readFileSync(cf);
	try {
		return c;
	} catch (e) {
		console.log(e)
	}
}

function ProcessConfigDir(cfdir) {
	var cff = fs.readdirSync(cfdir);
	cff.forEach(file => {
		if(file.split(".")[1] == "json") {
			if(file.match(/config.json$/)) {
				ProcessConfig(cfdir + file);
			}
		}
	})
	console.log(metars)
	console.log(zones)
}

function ProcessConfig(cf) {
	var cf_ = GetConfig(cf);
	// Go through the config file and find all instances of metar
	var cf_metars_regex = /\"metar\":\"....\"/g
	var cf_metars = cf_.toString().match(cf_metars_regex);	
	if (cf_metars) {
		cf_metars.forEach(metar => {
			metar = metar.split(":");
			if(metar[0] == "\"metar\"") {
				// Isolate out the metar and only insert unique entries
				var m = metar[1].replace(/\x22/g, "");
				if (metars.indexOf(m) === -1) {
					metars.push(m)
				}
			}
		})
	}

	// Go through the config file and find all instances of zone 
	var cf_zones_regex = /\"zone\":\"..z...\"/g
	var cf_zones = cf_.toString().match(cf_zones_regex);	
	if (cf_zones) {
		cf_zones.forEach(zone => {
			zone = zone.split(":");
			if(zone[0] == "\"zone\"") {
				// Isolate out the zones and only insert unique entries
				var z = zone[1].replace(/\x22/g, "");
				if (zones.indexOf(z) === -1) {
					zones.push(z)
				}
			}
		})
	}

	// Go through the config file and find all instances of wfo 
	var cf_wfo_regex = /\"wfo\":\"...\"/g
	var cf_wfo = cf_.toString().match(cf_wfo_regex);	
	if (cf_wfo) {
		cf_wfo.forEach(wfo => {
			wfo = wfo.split(":");
			if(wfo[0] == "\"wfo\"") {
				// Isolate out the zones and only insert unique entries
				var w = wfo[1].replace(/\x22/g, "");
				if (wfos.indexOf(w) === -1) {
					wfos.push(w)
				}
			}
		})
	}
}

function RequestMetar(metar) {
	// Node mechanism
	var options = {
		host: 'tgftp.nws.noaa.gov',
		port: 433,
		path: '/data/observations/metar/stations/' + metar + '.TXT',
		method: 'GET',
		headers: { 'User-Agent': 'Mozilla/5.0 NodeJS WS application' }
	}
	
	var req = https.request(options, function(res) {
		console.log('status: ' + res.statusCode);
		console.log('headers:' + JSON.stringify(res.headers));

		var body = '';
		res.setEncoding('utf8');
		res.on('data', function(chunk) {
			body += chunk;
		})
		res.on('end', function() {
			console.log('body: ' + body);
			try {
				fs.writeFileSync('./public/data/'+ metar +'.metar', body)
			} catch (e) {
				console.error(e)
			}
		})
	})
}

function RequestMetarShell(metar) {
	// This one is synchronous
	var unixtime = Math.round(Date.now() / 1000);

	// Check how old the file is
	var f = ('./public/data/' + metar + '.metar')
	if(fs.existsSync(f)){
		var fstat = fs.statSync(f);
		var mtime = fstat.mtime;
		var unix_mtime = (Math.round(new Date(mtime).getTime()/1000));
		// If it's less than 5 minutes old, skip
		if((unixtime - unix_mtime) > 300) {

			try {
				var stdout = execSync('curl ' + 
					'https://tgftp.nws.noaa.gov/data/observations/metar/stations/' +
					metar + '.TXT' +
					 ' ' + '-o ' + f);
				stdout = execSync('cp ' + './public/data/' + metar + '.metar ' + './public/data/active/' + metar + '.metar')
			} catch (e) {
		
			}

		} else {
			console.log("File up to date, skipping: " + f)
		}
	} else {
		try {
			var stdout = execSync('curl ' + 
				'https://tgftp.nws.noaa.gov/data/observations/metar/stations/' +
				metar + '.TXT' +
				 ' ' + '-o ' + f);
		} catch (e) {
		
		}
	}
}

function RequestZoneShell(zone) {
	// This one is synchronous
	try {
		var stdout = execSync('curl ' + 
			'https://tgftp.nws.noaa.gov/data/forecasts/zone/' +
			zone + '.txt' +
			 ' ' + '-o ./public/data/' + zone + '.txt');
	} catch (e) {

	}
}

function ValidateMetar(f) {
	var fr = fs.readFileSync(f);
	
	const hash = crypto.createHash('md5');
	hash.update(fr);
	return hash.digest('hex');
}

function CheckTime() {
	// Local time in unix timestamp
	var unixtime = Math.round(Date.now() / 1000)

	// Check time 
	// Every four hours
	if (unixtime % 14400 == 3600) {
		console.log("Fetch (four hours)")
	}
	// Every hour
	if (unixtime % 3600 == 0) {
		console.log("Fetch (hourly)")
	}
	// Every half hour
	if (unixtime % 1800 == 0) {
		console.log("Fetch (half hour)")
		metars.forEach(metar => {
			RequestMetarShell(metar);
		})
	}
	// Every five minutes
	if (unixtime % 300 ==  0) {
		metars.forEach(function (metar, i) {
			var f = ('./public/data/' + metar + '.metar')
			var fa = ('./public/data/active/' + metar + '.metar')
			var fah = ('./public/data/active/' + metar + '.metar.sum')
			if(fs.existsSync(f)){
				var fh = ValidateMetar(f);
				console.log(metar + ' ' + i + ' ' + fh)
			}
		})
		
	}
	// Every minute
	if (unixtime % 60 ==  0) {
		console.log("Reading from: " + cfdir)
		ProcessConfigDir(cfdir);
	}
}


if (process.argv.length > 2) {

	var validargs = 0;

	for (i=2; i<process.argv.length; i++) {

		if(process.argv[i] == "-c") {
			// Users can specify a config file
			validargs++;
			if(process.argv[i+1]) {
				if (fs.existsSync(process.argv[i+1])) {
					ProcessConfig(process.argv[i+1]);
				} else {
					console.log("File not found: " +
						process.argv[i+1])
						Usage();
				}
			} else {
				Usage();
			}

		} else if (process.argv[i] == "-d") {
			// Or a directory to read from
			validargs++;
			if(process.argv[i+1]) {
				if (fs.existsSync(process.argv[i+1])) {
					if(process.argv[3].endsWith('/')){
						ProcessConfigDir(process.argv[i+1]);
					} else {
						ProcessConfigDir(process.argv[i+1] + '/');
					}
				} else {
					console.log("Directory not found: " +
						process.argv[i+1])
					Usage();
				}
			} else {
				Usage();
			}
		}

	}

	if (validargs == 0) {
		Usage();
	}

} else {
	// Otherwise just search the default directory
	
	console.log("Fetching initial data.")
	// Read config file(s)
	var cfdir = './config/'
	console.log("Reading from: " + cfdir)
	// Match any file that ends with config.json
	ProcessConfigDir(cfdir);
	metars.forEach(metar => {
		RequestMetarShell(metar);
	})
	zones.forEach(zone => {
		//RequestZoneShell(zone);
	})
	setInterval(CheckTime, 1000);
//	while(true) {
//		
//
//	}
}
