const { exec } = require('child_process');
const { execSync } = require('child_process');
const fs = require('fs');
const path = require('path');
const WebSocket = require('ws');

//const omcw_wss = new WebSocket.WebSocketServer({ port: 6868 });
//const wss = new WebSocket.WebSocketSocket({ port: 8080 });
const ws = new WebSocket('ws://localhost:6868')
const delay = ms => new Promise(resolve => setTimeout(resolve, ms));


function Usage() {
	console.log("Usage: node " + path.basename(__filename) + 
		"\n\t[-c] [config.json]" + 
			"\tRead from specified config file." +
		"\n\t[-d] [./config/]" + 
			"\tRead config file(s) from this directory."
		)
}

function CleanChars(str) {
	// Replace shell chars with hex equivalent. 
	// We are passing directly into the shell
	// Beware of shell escapes
	str = str.replace(` `,`\\x20`);
	str = str.replace(`'`,`\\x27`);
	str = str.replace(`-`,`\\x2D`);
	str = str.replace(`_`,`\\x5F`);
	return str;
}

function RunScript(prod, args, span=0, attrib=[]) {
	// Retrieve product page json template.

	// The span param runs across multiple pages (tcf1, tcf2, ...)
	// For simplicity's sake, span takes number of lines to split
	// and divides by the line count. 

	// For example, a span of 9 divides 27 lines into 3 pages.
	// Each template file must exist of course.

	var sp = '';
	if (span !== 0) {
		// if span is specified look for the first template file
		sp = 1;
	}

	if (fs.existsSync('./json/'+prod+sp+'.template.json')) {
		var tp = fs.readFileSync('./json/'+prod+sp+'.template.json');
		try {
			var jx = JSON.parse(tp);
		} catch (e) {
			console.log(e)
		}
		if (jx) {
			var stdout = execSync('./public/'+prod+'.sh' + ' ' + args);
			var td = stdout.toString().split("\n");

			// if the last line is empty, drop it.
			if (td[td.length -1] == ''){
				td.splice(td.length -1, 1,)
			}
			
			// do not exceed the number of lines in the template
			var maxlines = (jx.pageData.lines.length);

			// now let's insert into json template
			if (span !== 0) {
				for (var j=0; j<(Math.ceil(td.length/span)); j++) {
					
					if (fs.existsSync('./json/'+
						prod+(sp+j)+'.template.json')) {
					
						var tp = fs.readFileSync('./json/' + 
							prod + (sp + j) +
							'.template.json');
						try {
							var jx = JSON.parse(tp);
						} catch (e) {
							console.log(e)
						}
			
						maxlines = (jx.pageData.lines.length);
						
						// lineCount is blindly assigned to span
						// TODO assign lineCount to remaining length of td
						jx.pageData.lineCount = span;

						for(var i=0; i<(span-1) && i<maxlines; i++) {
							// make sure the array object exists
							if(typeof td[i +(span*j)] !== 'undefined') {
								jx.pageData.lines[i].textData = 
									td[i +(span*j)];
							}
						}

						
						console.log(JSON.stringify(jx));
						ws.send(JSON.stringify(jx))
					} else {
						console.log('Page template not found: ' 
							+ prod + (sp + j) + '.template.json')
					}

				}
			} else {
				
				jx.pageData.lineCount = td.length;
				
				for(var i=0; i<td.length && i<maxlines; i++) {
					// make sure the array object exists
					if(typeof td[i] !== 'undefined') {
						jx.pageData.lines[i].textData = td[i];
					}
				}
				console.log(JSON.stringify(jx))
				ws.send(JSON.stringify(jx))
			}
		}
	} else {
		console.log('Page template not found: ' + prod + '.template.json')
	}
	
}

function GetConfig(cf) {
	// Get and return config file as json
	var c = fs.readFileSync(cf);
	try {
		return JSON.parse(c);
	} catch (e) {
		console.log(e)
	}
}

function ProcessConfigDir(cfdir) {
	var cff = fs.readdirSync(cfdir);
	cff.forEach(file => {
		if(file.split(".")[1] == "json") {
			if(file.match(/config.json$/)){
				ProcessConfig(cfdir + file);
			}
		}
	})
}

function ProcessConfig(cf) {
	// Extract config file
	var cfx = GetConfig(cf);
	if (cfx) {
		// Search for products
		for (var prod in cfx) {
			// Product page handlers, passed as arguments
			// Compile args, run the prod script with args

			var args = '';

			switch (prod) {
				case 'cc':
					args = args + " " + 
						(cfx.cc.metar + " " + "\"" + 
						CleanChars(cfx.cc.disploc) + "\"" + " " + 
						cfx.cc.meso)
					RunScript(prod, args);
					// Any additional scripts which share the same args
					if (cfx.cc.hasOwnProperty('include')){
						var prods = cfx.cc.include.split(' ');
						prods.forEach(iprod => {
							console.log(iprod)
							RunScript(iprod, args);
						})
					}
					break;
				case 'lo':
					for(var i=0; i<cfx.lo.length; i++){
						args = args + " " + 
							(cfx.lo[i].metar + "_" + "\"" + 
							CleanChars(cfx.lo[i].disploc) + "\"")
					}
					RunScript(prod, args);
					break;
				case 'rc':
					
					for(var i=0; i<cfx.rc.length; i++){
						args = args + " " + 
							(cfx.rc[i].metar + "_" + "\"" + 
							CleanChars(cfx.rc[i].disploc) + "\"")
					}
					RunScript(prod, args);
					break;
				case 'hrfc':
					args = " " + cfx.hrfc.zone;
					RunScript(prod, args, 9);
					break;
				case 'al':
					args = " " + cfx.al.lat 
						+ " " + cfx.al.lon
						+ " " + cfx.al.tz
						+ " " + cfx.al.metar;
					RunScript(prod, args);
					break;
					
			}


		}
	} else {
		console.log("Invalid config file: " + cfdir + file)
	}
}

// Open the web socket interface to send json packet data
ws.on('open', function message() {
	if (process.argv.length > 2) {
		
		var validargs = 0;
		
		for (i=2; i<process.argv.length; i++) {
			

			if(process.argv[i] == "-c") {
				// Users can specify a config file
				validargs++;
				if(process.argv[i+1]) {
					if (fs.existsSync(process.argv[i+1])) {
						ProcessConfig(process.argv[i+1]);
					} else {
						console.log("File not found: " + 
								process.argv[i+1])
						Usage();
					}
				} else {
					Usage();
				}

			} else if (process.argv[i] == "-d") {
				// Or a directory to read from
				validargs++;
				if(process.argv[i+1]) {
					if (fs.existsSync(process.argv[i+1])) {
						if(process.argv[3].endsWith('/')){
							ProcessConfigDir(process.argv[i+1]);
						} else {
							ProcessConfigDir(process.argv[i+1] + '/');
						}
					} else {
						console.log("Directory not found: " + 
								process.argv[i+1])
						Usage();
					}
				} else {
					Usage();
				}
			}

		}

		if (validargs == 0) {
			Usage();
		}

	} else {
		// Otherwise just search the default directory

		// Read config file(s)
		var cfdir = './config/'
		console.log("Reading from: " + cfdir)
		// Match any file that ends with config.json
		ProcessConfigDir(cfdir);	
	}
	ws.close();
});

