#!/bin/bash

SCRIPT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" &> /dev/null && pwd )"

# Args: (metar, disploc, meso)

if [ ! -z "$1" ] && [ "$1" != "undefined" ]; then
	metar="$1"
else
	metar="KMLI"
fi

if [ ! -z "$2" ] && [ "$2" != "undefined" ]; then
	disploc="$2"
else 
	disploc="Moline"
fi

if [ ! -z "$3" ] && [ "$3" != "undefined" ]; then
	meso="$3"
else
	meso="DVN"
fi

# Decode the metar and generate cc page

if [ -f $SCRIPT_DIR/data/active/$metar.metar ]; then

data=$(cat $SCRIPT_DIR/data/active/$metar.metar)

# Check if that file has anything in it
if [ ! -z "$data" ]; then
	
cc=$(
	echo "$data" | 
	gawk -v disploc=$disploc -v starfmt=1 -f $SCRIPT_DIR/metar.awk - | 
	fold -w 33 -s
)

printf "%s\n" "$cc"

# Check for monthly precip data, and print if it's available

# Technically this should be available regardless of cc data availablity
# But for authenticity, we will only show this if cc is valid

if [ -f $SCRIPT_DIR/data/$meso.mesonet.csv ]; then

	cc1=$(
		gawk -f $SCRIPT_DIR/meso.awk $SCRIPT_DIR/data/$meso.mesonet.csv
	)

	printf "%s\n" "$cc1"
fi

else

# Should data be empty, drop to no report

printf "Conditions at $disploc\nNo Current Report\n"

fi

else

# Should catch if the file is missing

printf "Conditions at $disploc\nNo Current Report\n"

fi

