#/bin/bash

SCRIPT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" &> /dev/null && pwd )"

# Number of seconds from issue data is valid for
valsec=86400

# First, check if the latest exfc data is up to date
o1=$(gawk -f /home/devonvroman/public/validate.awk /home/devonvroman/public/exfc.ason.latest)

d1=$(date -d $o1 -u +%s)
d2=$(date -u +%s)

echo $d1
echo $d2

if [ $((d2 - d1)) -gt $valsec ]
then
	> /home/devonvroman/public/exfc.ason.latest
else
	# If still good, copy latest data to current
	cat /home/devonvroman/public/exfc.ason.latest > /home/devonvroman/public/exfc.ason
fi

# Next, check if the current exfc is still good
o1=$(gawk -f /home/devonvroman/public/validate.awk /home/devonvroman/public/exfc.ason)

d1=$(date -d $o1 -u +%s)
d2=$(date -u +%s)

echo $d1
echo $d2

if [ $((d2 - d1)) -gt $valsec ]
then
	> /home/devonvroman/public/exfc.ason
fi
