const { exec } = require('child_process');
const { execSync } = require('child_process');
const fs = require('fs');
const WebSocket = require('ws');

//const omcw_wss = new WebSocket.WebSocketServer({ port: 6868 });
//const wss = new WebSocket.WebSocketSocket({ port: 8080 });
const ws = new WebSocket('ws://localhost:6868')
const delay = ms => new Promise(resolve => setTimeout(resolve, ms));

//exec('gawk -f ./awk/metar.awk ./data/KMLI.metar', (err, stdout, stderr) => {
//	console.log(`stdout: ${stdout}`);
//})


function GetConfig(cf) {
	// Get and return config file as json
	var c = fs.readFileSync(cf);
	try {
		return JSON.parse(c);
	} catch (e) {
		console.log(e)
	}
}


function CleanChars(str) {
	// Replace shell chars with hex equivalent. 
	// We are passing directly into the shell
	// Beware of shell escapes
	str = str.replace(` `,`\\x20`);
	str = str.replace(`'`,`\\x27`);
	str = str.replace(`-`,`\\x2D`);
	str = str.replace(`_`,`\\x5F`);
	return str;
}

function RunScript(prod, args, span=0, attrib=[]) {
	// Retrieve product page json template.

	// The span param runs across multiple pages (tcf1, tcf2, ...)
	// For simplicity's sake, span takes number of lines to split
	// and divides by the line count. 

	// For example, a span of 9 divides 27 lines into 3 pages.
	// Each template file must exist of course.

	var sp = '';
	if (span !== 0) {
		// if span is specified look for the first template file
		sp = 1;
	}

	if (fs.existsSync('./json/'+prod+sp+'.template.json')) {
		var tp = fs.readFileSync('./json/'+prod+sp+'.template.json');
		try {
			var jx = JSON.parse(tp);
		} catch (e) {
			console.log(e)
		}
		if (jx) {
			var stdout = execSync('./public/'+prod+'.sh' + ' ' + args);
			var td = stdout.toString().split("\n");

			// if the last line is empty, drop it.
			if (td[td.length -1] == ''){
				td.splice(td.length -1, 1,)
			}
			
			// do not exceed the number of lines in the template
			var maxlines = (jx.pageData.lines.length);

			// now let's insert into json template
			if (span !== 0) {
				for (var j=0; j<(Math.ceil(td.length/span)); j++) {
					
					if (fs.existsSync('./json/'+
						prod+(sp+j)+'.template.json')) {
					
						var tp = fs.readFileSync('./json/' + 
							prod + (sp + j) +
							'.template.json');
						try {
							var jx = JSON.parse(tp);
						} catch (e) {
							console.log(e)
						}
			
						maxlines = (jx.pageData.lines.length);
						
						// lineCount is blindly assigned to span
						// TODO assign lineCount to remaining length of td
						jx.pageData.lineCount = span;

						for(var i=0; i<(span-1) && i<maxlines; i++) {
							// make sure the array object exists
							if(typeof td[i +(span*j)] !== 'undefined') {
								jx.pageData.lines[i].textData = 
									td[i +(span*j)];
							}
						}

						
						console.log(JSON.stringify(jx));
						ws.send(JSON.stringify(jx))
						bufferdelay = bufferdelay + 144;	
					} else {
						console.log('Page template not found: ' 
							+ prod + (sp + j) + '.template.json')
					}

				}
			} else {
				
				jx.pageData.lineCount = td.length;
				
				for(var i=0; i<td.length-2 && i<maxlines; i++) {
					// make sure the array object exists
					if(typeof td[i] !== 'undefined') {
						jx.pageData.lines[i].textData = td[i];
					}
				}
				console.log(JSON.stringify(jx))
				ws.send(JSON.stringify(jx))
				bufferdelay = bufferdelay + 144;	
			}
		}
	} else {
		console.log('Page template not found: ' + prod + '.template.json')
	}
	
}

// Read config file(s)
var cfdir = './config/'
var cff = fs.readdirSync(cfdir);

// For each page, allow the product pages to flush
var bufferdelay = 0;

function ProcessConfig() {

// Match any file that ends with config.json
cff.forEach(file => {
	if(file.split(".")[1] == "json") {
		if(file.match(/config.json$/)){
			// Extract config file
			var cfx = GetConfig(cfdir + file);
			if (cfx) {
				// Search for products
				for (var prod in cfx) {
					// Product page handlers, passed as arguments
					// Compile args, run the prod script with args

					var args = '';

					switch (prod) {
						case 'cc':
							args = args + " " + 
								(cfx.cc.metar + " " + "\"" + 
								CleanChars(cfx.cc.disploc) + "\"" + " " + 
								cfx.cc.meso)
							RunScript(prod, args);
							break;
						case 'lo':
							for(var i=0; i<cfx.lo.length; i++){
								args = args + " " + 
									(cfx.lo[i].metar + "_" + "\"" + 
									CleanChars(cfx.lo[i].disploc) + "\"")
							}
							RunScript(prod, args);
							break;
						case 'rc':
							
							for(var i=0; i<cfx.rc.length; i++){
								args = args + " " + 
									(cfx.rc[i].metar + "_" + "\"" + 
									CleanChars(cfx.rc[i].disploc) + "\"")
							}
							RunScript(prod, args);
							break;
						case 'hrfc':
							args = " " + cfx.hrfc.zone;
							RunScript(prod, args, 9);
							break;
						case 'al':
							args = " " + cfx.al.lat +
								" " + cfx.al.lon +
								" " + cfx.al.tz +
								" " + cfx.al.metar;
							RunScript(prod, args);
							break;
							
					}


				}
			} else {
				console.log("Invalid config file: " + cfdir + file)
			}
		}
	}
})

}

ws.on('open', function message() {
	ProcessConfig();
	delay(bufferdelay);
	ws.close();
});
//exec('~/public/hrfcexp.sh', (err,stdout,stderr) => {
//	//console.log(`stdout: ${stdout}`);
//	var outsplit = stdout.split('\n');
//	//console.log(outsplit.length);
//})
