#!/bin/bash

SCRIPT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" &> /dev/null && pwd )"

# Args: (lat, lon, tz, metar)

if [ ! -z "$1" ]; then
	lat="$1"
else
	lat=41.44865
fi

if [ ! -z "$2" ]; then
	lon="$2"
else
	lon=90.50652
fi

if [ ! -z "$4" ]; then
	metar="$4"
else
	metar="KMLI"
fi

# Generate sunrise/sunset

# Day 1
yyyy=$(date +%Y)
mm=$(date +%0m) #note the leading zero
dd=$(date +%0d) #note the leading zero
day=$(date +%A)

tz=$(date +%z)

tzo=$( expr $tz / 100 )

# Day 2
yyyy1=$(date +%Y -d "+1 days")
mm1=$(date +%0m -d "+1 days") #note the leading zero
dd1=$(date +%0d -d "+1 days") #note the leading zero
day1=$(date +%A -d "+1 days")

tz1=$(date +%z -d "+1 days")

tzo1=$( expr $tz1 / 100 )

solar0=$($SCRIPT_DIR/solar $yyyy $mm $dd $lat $lon $tzo | sed -n 2p)
solar1=$($SCRIPT_DIR/solar $yyyy1 $mm1 $dd1 $lat $lon $tzo1 | sed -n 2p)

# Gather normals & output

printf "$day\n$solar0\n$day1\n$solar1\n" | gawk -v ntday0=$dd -v ntday1=$dd1 -v npmon=$mm -f $SCRIPT_DIR/almanac.awk - $SCRIPT_DIR/data/alman.$metar.2010.$mm.daily $SCRIPT_DIR/data/alman.$metar.2010.$mm1.daily $SCRIPT_DIR/data/alman.$metar.2010.monthly

