BEGIN {
	npmos = "Monthly"
}

{

if (FNR == 1) {
	filecount += 1
}

if ((NR - FNR) == 0) {
	if (NR == 1) {
		day0 = $1;
	}

	if (NR == 2) {
		srd0 = $2;
		ssd0 = $3;
	}

	if (NR == 3) {
		day1 = $1;
	}

	if (NR == 4) {
		srd1 = $2;
		ssd1 = $3;
	}
}

if (filecount == 2) {
	if ($1 == ntday0) {
		ntd0lo = int($2 + 0.5)
		ntd0hi = int($4 + 0.5)
	}
}

if (filecount == 3) {
	if ($1 == ntday1) {
		ntd1lo = int($2 + 0.5)
		ntd1hi = int($4 + 0.5)
	}
}

if (filecount == 4) {
	if ($1 == npmon) {
		np = $2
		if (int(npmon + 0) == 1) { npmons = sprintf("January") }
		if (int(npmon + 0) == 2) { npmons = sprintf("Feburary") }
		if (int(npmon + 0) == 3) { npmons = sprintf("March") }
		if (int(npmon + 0) == 4) { npmons = sprintf("April") }
		if (int(npmon + 0) == 5) { npmons = sprintf("May") }
		if (int(npmon + 0) == 6) { npmons = sprintf("June") }
		if (int(npmon + 0) == 7) { npmons = sprintf("July") }
		if (int(npmon + 0) == 8) { npmons = sprintf("August") }
		if (int(npmon + 0) == 9) { npmons = sprintf("September") }
		if (int(npmon + 0) == 10) { npmons = sprintf("October") }
		if (int(npmon + 0) == 11) { npmons = sprintf("November") }
		if (int(npmon + 0) == 12) { npmons = sprintf("December") }
	}
}



} END {

# Prep the Sunrise/Sunset times
if (!hr24) {
	for (j = 0; j < 4; j++) {
		cbuf = ""
		if (j == 0) {cbuf = srd0}
		if (j == 1) {cbuf = srd1}
		if (j == 2) {cbuf = ssd0}
		if (j == 3) {cbuf = ssd1}

		split(cbuf, cbufx, ":")
		chr = cbufx[1]
		chr = chr + 0
		if (chr >= 12) {
			cmer = "pm"
		} else {
			cmer = "am"
		}
		chr = chr % 12
		if (chr == 0) {
			chr = 12
		}
		cmin = cbufx[2]
		cbuf = sprintf("%s:%s %s", chr, cmin, cmer)

		if (j == 0) {srd0 = cbuf}
		if (j == 1) {srd1 = cbuf}
		if (j == 2) {ssd0 = cbuf}
		if (j == 3) {ssd1 = cbuf}
	}
}


printf("  The Weather Channel Almanac\n\n");

# Print sunrise/set days (centered)
printf("             ");
m = 9;
# Day 1
l = m - length(day0);
for (i=1; i <= int(l / 2); i++) {
	printf(" ");
}
printf("%s", day0);
for (i=1; i <= int(l / 2 + 0.5); i++) {
	printf(" ");
}
printf(" ");

# Day 2
l = m - length(day1);
for (i=1; i <= int(l / 2); i++) {
	printf(" ");
}
printf("%s", day1);
for (i=1; i <= int(l / 2 + 0.5); i++) {
	printf(" ");
}
printf("\n");

# Sunrise/set (also centered) 
# Sunrise
m = 9;
printf("Sunrise      ");
l = m - length(srd0);
for (i=1; i <=int (l /2); i++) {
	printf(" ");
}
printf("%s", srd0);
for (i=1; i <= int(l / 2 + 0.5); i++) {
	printf(" ");
}
printf(" ");
l = m - length(srd1);
for (i=1; i <=int (l /2); i++) {
	printf(" ");
}
printf("%s", srd1);
for (i=1; i <= int(l / 2 + 0.5); i++) {
	printf(" ");
}
printf("\n");

# Sunset
m = 9;
printf("Sunset       ");
l = m - length(ssd0);
for (i=1; i <=int (l /2); i++) {
	printf(" ");
}
printf("%s", ssd0);
for (i=1; i <= int(l / 2 + 0.5); i++) {
	printf(" ");
}
printf(" ");
l = m - length(ssd1);
for (i=1; i <=int (l /2); i++) {
	printf(" ");
}
printf("%s", ssd1);
for (i=1; i <= int(l / 2 + 0.5); i++) {
	printf(" ");
}
printf("\n");

printf("Normal Low     %3s \\F    %3s \\F\n", ntd0lo, ntd1lo);
printf("Normal High    %3s \\F    %3s \\F\n", ntd0hi, ntd1hi);
printf("\n");
printf("Normal %s Precip ", npmons);
for (i=1; i <= (25 - (15 + length(npmons))); i++) {
	printf(" ");
}
# Monthly normal precip

np += 0
nps = sprintf("%1.1fin", np)

m = 5
l = m - length(nps);
for (i=1; i <=int (l /2); i++) {
	printf(" ");
}
printf("%s", nps);
for (i=1; i <= int(l / 2 + 0.5); i++) {
	printf(" ");
}
printf("\n");
}
