#!/bin/bash

SCRIPT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" &> /dev/null && pwd )"

# Args: zone

USEJSON=0

if [ -z "$1" ]; then
zone=$1
else
zone=ilz015
fi

if [ -z "$2" ]; then
pagenum=$2
else
pagenum=0
fi

if [ $USEJSON == 1 ]; then

hrfc=$(
	gawk -f $SCRIPT_DIR/JSON.awk $SCRIPT_DIR/data/$zone.fc.json;
)

fc=$(
	echo "$hrfc" | gawk -f $SCRIPT_DIR/jsfc.awk - | 
	gawk -f $SCRIPT_DIR/pagewrap.awk
)

else

if [ -f $SCRIPT_DIR/data/$zone.txt ]; then
hrfc=$(
	gawk -f $SCRIPT_DIR/hrfc.awk -v NOFCAST=1 $SCRIPT_DIR/data/$zone.txt |
	sed -e 's/[...]//g' | 
	fold -s -w 30 | 
	gawk -f $SCRIPT_DIR/warnwrap.awk;

	gawk -f $SCRIPT_DIR/hrfc.awk -v NOWARN=1 $SCRIPT_DIR/data/$zone.txt |
	sed -e 's/^.//g' | 
	tr '[:lower:]' '[:upper:]'
)

fc=$(echo "$hrfc" | gawk -v TOUPPER=1 -f $SCRIPT_DIR/pagewrap.awk - )

fi

fi

fc1=$(echo "$fc" | gawk -v pagenum=0 -f $SCRIPT_DIR/fc.awk - )

echo "$fc1"

