#!/bin/bash

SCRIPT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" &> /dev/null && pwd )"

echo " Travel Cities Forecast" > $SCRIPT_DIR/tcf

echo "" >> $SCRIPT_DIR/tcf

echo "City           Weather   Low  Hi" >> $SCRIPT_DIR/tcf

gawk -f $SCRIPT_DIR/rf_t.awk \
	-v loc="Atlanta" \
	-v disploc="Atlanta" \
	$SCRIPT_DIR/data/gaz033.rfc.txt \
	$SCRIPT_DIR/t_lookup.txt \
	>> $SCRIPT_DIR/tcf;

gawk -f $SCRIPT_DIR/rf_t.awk \
	-v loc="Boston\. MA" \
	-v disploc="Boston" \
	$SCRIPT_DIR/data/maz015.rfc.txt \
	$SCRIPT_DIR/t_lookup.txt \
	>> $SCRIPT_DIR/tcf;

gawk -f $SCRIPT_DIR/rf_t.awk \
	-v loc="Chicago O'Hare" \
	-v disploc="Chicago\/O Hare" \
	$SCRIPT_DIR/data/ilz104.rfc.txt \
	$SCRIPT_DIR/t_lookup.txt \
	>> $SCRIPT_DIR/tcf;

gawk -f $SCRIPT_DIR/rf_t.awk \
	-v loc="Cleveland" \
	-v disploc="Cleveland" \
	$SCRIPT_DIR/data/ohz011.rfc.txt \
	$SCRIPT_DIR/t_lookup.txt \
	>> $SCRIPT_DIR/tcf;

gawk -f $SCRIPT_DIR/rf_t.awk \
	-v loc="Dallas-Ft. Worth Airport TX" \
	-v disploc="Dallas\/Ft Wrth" \
	$SCRIPT_DIR/data/txz118.rfc.txt \
	$SCRIPT_DIR/t_lookup.txt \
	>> $SCRIPT_DIR/tcf;

gawk -f $SCRIPT_DIR/rf_t.awk \
	-v loc="DENVER" \
	-v disploc="Denver" \
	$SCRIPT_DIR/data/coz040.rfc.txt \
	$SCRIPT_DIR/t_lookup.txt \
	>> $SCRIPT_DIR/tcf;

gawk -f $SCRIPT_DIR/rf_t.awk \
	-v loc="Detroit" \
	-v disploc="Detroit" \
	$SCRIPT_DIR/data/miz076.rfc.txt \
	$SCRIPT_DIR/t_lookup.txt \
	>> $SCRIPT_DIR/tcf;

gawk -f $SCRIPT_DIR/rf_t.awk \
	-v loc="Hartford\, CT" \
	-v disploc="Hartford" \
	$SCRIPT_DIR/data/ctz002.rfc.txt \
	$SCRIPT_DIR/t_lookup.txt \
	>> $SCRIPT_DIR/tcf;

gawk -f $SCRIPT_DIR/rf_t.awk \
	-v loc="HOUSTON" \
	-v disploc="Houston" \
	$SCRIPT_DIR/data/txz213.rfc.txt \
	$SCRIPT_DIR/t_lookup.txt \
	>> $SCRIPT_DIR/tcf;

gawk -f $SCRIPT_DIR/rf_t.awk \
	-v loc="Los Angeles Intl Airport" \
	-v disploc="Los Angeles" \
	$SCRIPT_DIR/data/caz041.rfc.txt \
	$SCRIPT_DIR/t_lookup.txt \
	>> $SCRIPT_DIR/tcf;

gawk -f $SCRIPT_DIR/rf_t.awk \
	-v loc="Miami" \
	-v disploc="Miami" \
	$SCRIPT_DIR/data/flz173.rfc.txt \
	$SCRIPT_DIR/t_lookup.txt \
	>> $SCRIPT_DIR/tcf;

gawk -f $SCRIPT_DIR/rf_t.awk \
	-v loc="Minneapolis" \
	-v disploc="Minneapolis" \
	$SCRIPT_DIR/data/mnz012.rfc.txt \
	$SCRIPT_DIR/t_lookup.txt \
	>> $SCRIPT_DIR/tcf;

gawk -f $SCRIPT_DIR/rf_t.awk \
	-v loc="Central Park\, NY" \
	-v disploc="New York" \
	$SCRIPT_DIR/data/nyz072.rfc.txt \
	$SCRIPT_DIR/t_lookup.txt \
	>> $SCRIPT_DIR/tcf;

gawk -f $SCRIPT_DIR/rf_t.awk \
	-v loc="NORFOLK" \
	-v disploc="Norfolk" \
	$SCRIPT_DIR/data/vaz095.rfc.txt \
	$SCRIPT_DIR/t_lookup.txt \
	>> $SCRIPT_DIR/tcf;

gawk -f $SCRIPT_DIR/rf_t.awk \
	-v loc="Orlando" \
	-v disploc="Orlando" \
	$SCRIPT_DIR/data/flz045.rfc.txt \
	$SCRIPT_DIR/t_lookup.txt \
	>> $SCRIPT_DIR/tcf;

gawk -f $SCRIPT_DIR/rf_t.awk \
	-v loc="Philadelphia" \
	-v disploc="Philadelphia" \
	$SCRIPT_DIR/data/paz071.rfc.txt \
	$SCRIPT_DIR/t_lookup.txt \
	>> $SCRIPT_DIR/tcf;

gawk -f $SCRIPT_DIR/rf_t.awk \
	-v loc="Pittsburgh" \
	-v disploc="Pittsburgh" \
	$SCRIPT_DIR/data/paz021.rfc.txt \
	$SCRIPT_DIR/t_lookup.txt \
	>> $SCRIPT_DIR/tcf;

gawk -f $SCRIPT_DIR/rf_t.awk \
	-v loc="Saint Louis" \
	-v disploc="Saint Louis" \
	$SCRIPT_DIR/data/moz064.rfc.txt \
	$SCRIPT_DIR/t_lookup.txt \
	>> $SCRIPT_DIR/tcf;

gawk -f $SCRIPT_DIR/rf_t.awk \
	-v loc="San Francisco" \
	-v disploc="San Francisco" \
	$SCRIPT_DIR/data/caz006.rfc.txt \
	$SCRIPT_DIR/t_lookup.txt \
	>> $SCRIPT_DIR/tcf;

gawk -f $SCRIPT_DIR/rf_t.awk \
	-v loc="Seattle" \
	-v disploc="Seattle-Tacoma" \
	$SCRIPT_DIR/data/waz505.rfc.txt \
	$SCRIPT_DIR/t_lookup.txt \
	>> $SCRIPT_DIR/tcf;

gawk -f $SCRIPT_DIR/rf_t.awk \
	-v loc="Tampa" \
	-v disploc="Tampa" \
	$SCRIPT_DIR/data/flz151.rfc.txt \
	$SCRIPT_DIR/t_lookup.txt \
	>> $SCRIPT_DIR/tcf;

gawk -f $SCRIPT_DIR/rf_t.awk \
	-v loc="Washington DC" \
	-v disploc="Washington DC" \
	$SCRIPT_DIR/data/dcz001.rfc.txt \
	$SCRIPT_DIR/t_lookup.txt \
	>> $SCRIPT_DIR/tcf;

